/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.util;

import com.alexander.mutantmore.capabilities.EntityHeatProvider;
import com.alexander.mutantmore.config.HeatCommonConfig;
import com.alexander.mutantmore.interfaces.IHeatSource;
import com.alexander.mutantmore.network.Messages;
import com.alexander.mutantmore.network.ServerToClientUpdatePlayerHeatPacket;
import com.alexander.mutantmore.particles.CirclingParticleOption;
import com.alexander.mutantmore.util.MiscUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class HeatUtils {
    public static RandomSource random = RandomSource.m_216327_();

    public static void performHeating(IHeatSource heatSource, BlockPos pos, Level level, double heatSpeed) {
        if (heatSource.heatRange() > 0.0) {
            HeatUtils.createHeatParticles(heatSource, pos, level);
            HeatUtils.heatNearbyMobs(heatSource, pos, level, heatSpeed);
        }
    }

    public static void createHeatParticles(IHeatSource heatSource, BlockPos pos, Level level) {
        if (level.f_46443_) {
            for (int j = 0; j < 4; ++j) {
                float heightIncrease = heatSource instanceof Entity ? ((Entity)heatSource).m_20206_() : 0.0f;
                int i = (int)(-heatSource.heatRangeY());
                while ((double)i < heatSource.heatRangeY() + (double)heightIncrease) {
                    boolean createParticle = false;
                    if (i != 0) {
                        if (i < 0) {
                            if (random.m_188503_(1 + -i / 2) == 0) {
                                createParticle = true;
                            }
                        } else if (random.m_188503_(1 + i / 2) == 0) {
                            createParticle = true;
                        }
                    } else {
                        createParticle = true;
                    }
                    if (createParticle && random.m_188499_()) {
                        int heatSourceID = heatSource instanceof Entity ? ((Entity)heatSource).m_19879_() : 0;
                        level.m_7106_((ParticleOptions)new CirclingParticleOption("mutantmore:heat", heatSource.heatRange(), MiscUtils.degToRad(random.m_188501_() * 360.0f), 0.001f + random.m_188501_() * 0.05f, heatSourceID, 0.0, i, 0.0), (double)pos.m_123341_(), (double)(pos.m_123342_() + i), (double)pos.m_123343_(), 0.0, 0.0, 0.0);
                    }
                    ++i;
                }
            }
        }
    }

    public static void heatNearbyMobs(IHeatSource heatSource, BlockPos pos, Level level, double heatSpeed) {
        if (!level.f_46443_) {
            TargetingConditions.m_148353_().m_26883_(heatSource.heatRange()).m_26893_();
            TargetingConditions heatTargeting = TargetingConditions.m_148352_();
            for (Entity heatableEntity : level.m_45933_(heatSource instanceof Entity ? (Entity)heatSource : null, HeatUtils.createHeatRange(heatSource, pos))) {
                if (!(heatableEntity instanceof LivingEntity)) continue;
                heatableEntity.getCapability(EntityHeatProvider.ENTITY_HEAT).ifPresent(data -> {
                    if (heatSource.canHeat((LivingEntity)heatableEntity)) {
                        data.setHeat(data.getHeat() + heatSpeed);
                        data.setCoolDelay((Integer)HeatCommonConfig.cool_down_delay.get());
                        if (heatableEntity instanceof ServerPlayer) {
                            Messages.sendToPlayer(new ServerToClientUpdatePlayerHeatPacket(data.getHeat()), (ServerPlayer)heatableEntity);
                        }
                    }
                });
            }
        }
    }

    public static AABB createHeatRange(IHeatSource heatSource, BlockPos pos) {
        if (heatSource instanceof Entity) {
            return ((Entity)heatSource).m_20191_().m_82377_(heatSource.heatRange(), heatSource.heatRangeY(), heatSource.heatRange());
        }
        return new AABB(pos).m_82377_(heatSource.heatRange(), heatSource.heatRangeY(), heatSource.heatRange());
    }
}

